#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>
using namespace std;
long long int crveni=0;
long long int plavi=0;
long long int kostanje=0;
struct cvor
{
    long long int koji;
    long long int cost;
    long long int povezanih;

};

struct Graph
{
    long long int n;
    vector<vector<long long int> > adj;
    vector<cvor > v;
    vector<long long int> boja;
};

void init_graph(Graph &g, long long int n)
{
    g.n=n;
    g.adj.resize(n);
    g.boja.resize(n,0);
    for(long long int i=0;i<n;i++)
    {
        long long int x;
        cin >>x;
        cvor pom;
        pom.koji=i;
        pom.cost=x;
        pom.povezanih=0;
        g.v.push_back(pom);
    }
}

void addEdge(Graph &g,long long int u,long long int v)
{
    g.adj[u].push_back(v);
    g.adj[v].push_back(u);
    g.v[u].povezanih++;
    g.v[v].povezanih++;

}

void oboji(Graph &g)
{
    queue<long long int> q;
    queue<long long int> color;
    q.push(0);
    color.push(1);
    g.boja[0]=1;
    crveni++;
    kostanje+=g.v[0].cost;
    while(!q.empty())
    {
        long long int pom=q.front();
        long long int pomcol=color.front();
        q.pop();
        color.pop();

        for(long long int i=0;i<g.adj[pom].size();i++)
        {
            if(g.boja[g.adj[pom][i]]==0)
            {
               g.boja[g.adj[pom][i]]=pomcol*(-1);
               if(pomcol==1)
               {
                   plavi++;
               }
               else
               {
                   crveni++;
               }
               q.push(g.adj[pom][i]);
               color.push(pomcol*(-1));
               kostanje+=g.v[g.adj[pom][i]].cost;
            }

        }

    }

}
bool cmp(cvor prvi, cvor drugi)
{
    if(prvi.cost>drugi.cost) return true;
    if(prvi.cost==drugi.cost &&prvi.povezanih>drugi.povezanih) return true;

    return false;
}
void odboji(Graph &g)
{
    sort(g.v.begin(),g.v.end(),cmp);
    for(long long int i=0;i<g.n;i++)
    {
        cout <<g.v[i].cost<<" "<<g.v[i].povezanih<<"\n";
        long long int k=g.v[i].koji;
        long long int t=true;
        for(long long int j=0;j<g.adj[k].size();j++)
        {
            if(g.boja[g.adj[k][j]]==0)
            {
                t=false;
                break;
            }
        }
        if(t)
        {
            kostanje-=g.v[i].cost;
            if(g.boja[k]==1)
            {
                crveni--;
            }
            else
            {
                plavi--;
            }
            g.boja[k]=0;
        }
    }

}
int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    long long int n;
    cin >>n;
    Graph g;
    init_graph(g,n);
    for(long long int i=0;i<n-1;i++)
    {
        long long int u,v;
        cin >>u>>v;
        addEdge(g,u-1,v-1);
    }

    //oboji
    oboji(g);
    /*cout <<crveni<<"\n";
    cout <<plavi<<"\n";
    cout <<kostanje<<"\n";
    */
    //odboji
    odboji(g);
    cout <<kostanje<<"\n";
    cout <<crveni<<"\n";
    if(crveni!=0)
    {

    for(long long int i=0;i<g.n;i++)
    {
        if(g.boja[i]==1)
        {
            cout <<i+1<<" ";
        }
    }
    cout <<"\n";
    }
    cout <<plavi<<"\n";
    if(plavi!=0)
    {

    for(long long int i=0;i<g.n;i++)
    {
        if(g.boja[i]==-1)
        {
            cout <<i+1<<" ";
        }
    }
    cout <<"\n";
    }
    return 0;
}